#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_PatientTransfusionReaction : BaseTest 
	{

		#region Variables

		private DataTable _dtGuids;
		private DataTable _dtPatient;
		

		private DataRow _setUpData;
		private DataRow _existingData;

		private DataTable _dtPTR;

		#endregion

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//Get patient information for any data that we need to create
				this._dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient WHERE RecordStatusCode = 'C' AND LastUpdateFunctionId = 0", true);

				//Get patient information for any data that we need to create
				this._dtPTR = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientTransfusionReaction WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", false);
				if (this._dtPTR.Rows.Count == 0)
				{
					new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveImplicatedBloodUnits_Pass();
					this._dtPTR = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM PatientTransfusionReaction WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				}

				string strSQL = "SELECT TOP 1 PTR.PatientTransfusionReactionGuid, PTR.PatientGuid FROM Patient P " +
				" JOIN PatientTransfusionReaction PTR ON PTR.PatientGuid = P.PatientGuid " +
				" LEFT OUTER JOIN PatientTransfusion PT ON PT.PatientGuid = P.PatientGuid " +
				" JOIN TransfusionReaction TR ON TR.PatientTransfusionGuid = PT.PatientTransfusionGuid " +
				" AND TR.PatientTransfusionReactionGuid = PTR.PatientTransfusionReactionGuid " +
				" JOIN TransfusionReactionType TRT ON TRT.TransfusionReactionTypeCode = PTR.TransfusionReactionTypeCode " +
				" WHERE PTR.RecordStatusCode NOT IN ('E','X')";
				
				this._dtGuids = UnitTestUtil.RunSQLGetDataTable(strSQL, false);
	
				if (this._dtGuids.Rows.Count <= 0)
				{
					this.CreateTestData();
					this._dtGuids = UnitTestUtil.RunSQLGetDataTable(strSQL, true);
				}

				this.RefreshData = false;
			}

			this._setUpData = GetDataForPersistingNewPtr();
			this._existingData = GetPtrData();
		}

		[Test]
		public void GetEmptyPatientTransfusionReactionTable_Pass()
		{
			DataTable dt = DAL.PatientTransfusionReaction.GetEmptyPatientTransfusionReactionTable();

			Assert.AreEqual(TABLES.PatientTransfusionReaction.TableName, dt.TableName, "TableName");
			Assert.AreEqual(23, dt.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.DivisionCode), TABLES.PatientTransfusionReaction.DivisionCode);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.EntryDateTime), TABLES.PatientTransfusionReaction.EntryDateTime);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.EntryTechId), TABLES.PatientTransfusionReaction.EntryTechId);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.InvestigatedDateTime), TABLES.PatientTransfusionReaction.InvestigatedDateTime);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.LastUpdateDate), TABLES.PatientTransfusionReaction.LastUpdateDate);
			
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.LastUpdateUser), TABLES.PatientTransfusionReaction.LastUpdateUser);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.MedicalDirectorName), TABLES.PatientTransfusionReaction.MedicalDirectorName);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.NotedDateTime), TABLES.PatientTransfusionReaction.NotedDateTime);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.OrderedTestGuid), TABLES.PatientTransfusionReaction.OrderedTestGuid);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PartialSaveId), TABLES.PatientTransfusionReaction.PartialSaveId);
			
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PatientGuid), TABLES.PatientTransfusionReaction.PatientGuid);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator), TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator), TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator), TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator);
			
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator), TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode), TABLES.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode), TABLES.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.RecordStatusCode), TABLES.PatientTransfusionReaction.RecordStatusCode);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.RowVersion), TABLES.PatientTransfusionReaction.RowVersion);
			
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode), TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenGuid), TABLES.PatientTransfusionReaction.PreSpecimenGuid);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenGuid), TABLES.PatientTransfusionReaction.PostSpecimenGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetEmptyPatientTransfusionReactionTable_Fail()
		{
		}

		[Test]
		public void GetHemolysisInspectionList_Pass()
		{
			DataTable dtTest = DAL.PatientTransfusionReaction.GetHemolysisInspectionList();

			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HemolysisInspection.HemolysisInspectionCode), TABLES.HemolysisInspection.HemolysisInspectionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HemolysisInspection.HemolysisInspectionText), TABLES.HemolysisInspection.HemolysisInspectionText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HemolysisInspection.SortColumn), TABLES.HemolysisInspection.SortColumn);
			
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetHemolysisInspectionList_Fail()
		{
		}

		[Test]
		public void GetImplicatedBloodUnits_Pass()
		{
			Guid patientGuid = (Guid)this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];

			DataTable dtTest = DAL.PatientTransfusionReaction.GetImplicatedBloodUnits(patientGuid, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(44, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.UnitStatusRowVersion), ARTIFICIAL.UnitStatusRowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.PatientTransfusionGuid), TABLES.PatientTransfusion.PatientTransfusionGuid);
		}

		[Test]
		public void GetImplicatedBloodUnits_Fail()
		{
			try		//PatientGuid
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetImplicatedBloodUnits(Guid.Empty, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, "1-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try		//DivisionCode
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetImplicatedBloodUnits(Guid.NewGuid(), string.Empty);
				Assert.IsTrue(false, "2-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetImplicatedTransfusionRecords_Pass()
		{
			Guid patientGuid = (Guid)this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];

			DataTable dtTest = DAL.PatientTransfusionReaction.GetImplicatedTransfusionRecords(patientGuid, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(17, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.PatientTransfusionGuid), TABLES.PatientTransfusion.PatientTransfusionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.PatientGuid), TABLES.PatientTransfusion.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.TransfusionLocation), TABLES.PatientTransfusion.TransfusionLocation);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.LocationIen), TABLES.PatientTransfusion.LocationIen);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.TransfusionStartDateTime), TABLES.PatientTransfusion.TransfusionStartDateTime);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.TransfusionEndDateTime), TABLES.PatientTransfusion.TransfusionEndDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.BloodUnitGuid), TABLES.PatientTransfusion.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.Transfusionist1Id), TABLES.PatientTransfusion.Transfusionist1Id);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.Transfusionist2Id), TABLES.PatientTransfusion.Transfusionist2Id);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.TransfusedVolume), TABLES.PatientTransfusion.TransfusedVolume);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.InterruptionIndicator), TABLES.PatientTransfusion.InterruptionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.ReactionIndicator), TABLES.PatientTransfusion.ReactionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.ReactionSymptoms), TABLES.PatientTransfusion.ReactionSymptoms);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.DivisionCode), TABLES.PatientTransfusion.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.LastUpdateUser), TABLES.PatientTransfusion.LastUpdateUser);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.LastUpdateFunctionId), TABLES.PatientTransfusion.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.RowVersion), TABLES.PatientTransfusion.RowVersion);
		}

		[Test]
		public void GetImplicatedTransfusionRecords_Fail()
		{
			try		//PatientGuid
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetImplicatedTransfusionRecords(Guid.Empty, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, "1-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try		//DivisionCode
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetImplicatedTransfusionRecords(Guid.NewGuid(), string.Empty);
				Assert.IsTrue(false, "2-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetImplicatedTransfusionRecordsForPatientTransfusionReaction_Pass()
		{
			Guid ptrGuid = (Guid)this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];

			DataTable dtTest = DAL.PatientTransfusionReaction.GetImplicatedTransfusionRecordsForPatientTransfusionReaction(ptrGuid, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(46, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BiohazardousWarningIndicator), TABLES.BloodUnitStatus.BiohazardousWarningIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.UnitStatusRowVersion), ARTIFICIAL.UnitStatusRowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FullProductCode), ARTIFICIAL.FullProductCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.PatientTransfusionGuid), TABLES.PatientTransfusion.PatientTransfusionGuid);		
		}

		[Test]
		public void GetImplicatedTransfusionRecordsForPatientTransfusionReaction_Fail()
		{
			try		//PatientTransfusionGuid
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetImplicatedTransfusionRecordsForPatientTransfusionReaction(Guid.Empty, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, "1-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try		//DivisionCode
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetImplicatedTransfusionRecordsForPatientTransfusionReaction(Guid.NewGuid(), string.Empty);
				Assert.IsTrue(false, "2-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetPatientTransfusionReaction_Pass()
		{
			Guid unitGuid = (Guid)this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];

			DataTable dtTest = DAL.PatientTransfusionReaction.GetPatientTransfusionReaction(unitGuid, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(25, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.OrderedTestGuid), TABLES.PatientTransfusionReaction.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientGuid), TABLES.PatientTransfusionReaction.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.NotedDateTime), TABLES.PatientTransfusionReaction.NotedDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.InvestigatedDateTime), TABLES.PatientTransfusionReaction.InvestigatedDateTime);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode), TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), TABLES.TransfusionReactionType.TransfusionReactionTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.EntryTechId), TABLES.PatientTransfusionReaction.EntryTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.EntryDateTime), TABLES.PatientTransfusionReaction.EntryDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.MedicalDirectorName), TABLES.PatientTransfusionReaction.MedicalDirectorName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator), TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator), TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator), TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator), TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode), TABLES.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode), TABLES.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PartialSaveId), TABLES.PatientTransfusionReaction.PartialSaveId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.DivisionCode), TABLES.PatientTransfusionReaction.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.RecordStatusCode), TABLES.PatientTransfusionReaction.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.LastUpdateDate), TABLES.PatientTransfusionReaction.LastUpdateDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.LastUpdateUser), TABLES.PatientTransfusionReaction.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.LastUpdateFunctionId), TABLES.PatientTransfusionReaction.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.RowVersion), TABLES.PatientTransfusionReaction.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenGuid), TABLES.PatientTransfusionReaction.PreSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenGuid), TABLES.PatientTransfusionReaction.PostSpecimenGuid);

		}

		[Test]
		public void GetPatientTransfusionReaction_Fail()
		{
			try		//UnitGuid
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetPatientTransfusionReaction(Guid.Empty, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, "1-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try		//DivisionCode
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetPatientTransfusionReaction(Guid.NewGuid(), string.Empty);
				Assert.IsTrue(false, "2-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetCompletedPatientTransfusionReactions_Pass()
		{
			DataTable dtTest = DAL.PatientTransfusionReaction.GetCompletedPatientTransfusionReactions();

			Assert.AreEqual(19, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientGuid), TABLES.PatientTransfusionReaction.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode), TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), TABLES.TransfusionReactionType.TransfusionReactionTypeText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.OrderedTestGuid), TABLES.PatientTransfusionReaction.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator), TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenGuid), TABLES.PatientTransfusionReaction.PreSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PreSpecimenUid), ARTIFICIAL.PreSpecimenUid);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenGuid), TABLES.PatientTransfusionReaction.PostSpecimenGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PostSpecimenUid), ARTIFICIAL.PostSpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PartialSaveId), TABLES.PatientTransfusionReaction.PartialSaveId);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CompletedDateTime), ARTIFICIAL.CompletedDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FinalizedDateTime), ARTIFICIAL.FinalizedDateTime);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCompletedPatientTransfusionReactions_Fail()
		{
		}

		[Test]
		public void GetPatientTransfusionReactionReport_Pass()
		{
			Guid ptrGuid = (Guid)this._dtPTR.Rows[0][TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid];

			DataSet dsTest = DAL.PatientTransfusionReaction.GetPatientTransfusionReactionReport(ptrGuid);
			Assert.AreEqual(4, dsTest.Tables.Count, "Tables.Count");

			//First table -------------------------------
			DataTable dtTest = dsTest.Tables[0];
			Assert.AreEqual(41, dtTest.Columns.Count, "[0]-Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), "[0]-" + TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientGuid), "[0]-" + TABLES.PatientTransfusionReaction.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), "[0]-" + TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), "[0]-" + TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), "[0]-" + TABLES.Patient.PatientMiddleName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), "[0]-" + TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.NotedDateTime), "[0]-" + TABLES.PatientTransfusionReaction.NotedDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.InvestigatedDateTime), "[0]-" + TABLES.PatientTransfusionReaction.InvestigatedDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode), "[0]-" + TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), "[0]-" + TABLES.TransfusionReactionType.TransfusionReactionTypeText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.EntryTechId), "[0]-" + TABLES.PatientTransfusionReaction.EntryTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.EntryDateTime), "[0]-" + TABLES.PatientTransfusionReaction.EntryDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.MedicalDirectorName), "[0]-" + TABLES.PatientTransfusionReaction.MedicalDirectorName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator), "[0]-" + TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator), "[0]-" + TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator), "[0]-" + TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator), "[0]-" + TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.PreSpecimenUid), "[0]-" + ARTIFICIAL.PreSpecimenUid);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.PreHemolysisInspectionCode), "[0]-" + ARTIFICIAL.PreHemolysisInspectionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PreHemolysisInspectionText), "[0]-" + ARTIFICIAL.PreHemolysisInspectionText);
			
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.PostSpecimenUid), "[0]-" + ARTIFICIAL.PostSpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PostHemolysisInspectionCode), "[0]-" + ARTIFICIAL.PostHemolysisInspectionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PostHemolysisInspectionText), "[0]-" + ARTIFICIAL.PostHemolysisInspectionText);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.PreNACannedCommentGuid), "[0]-" + ARTIFICIAL.PreNACannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PreNACommentText), "[0]-" + ARTIFICIAL.PreNACommentText);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PostNACannedCommentGuid), "[0]-" + ARTIFICIAL.PostNACannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PostNACommentText), "[0]-" + ARTIFICIAL.PostNACommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PreCCCannedCommentGuid), "[0]-" + ARTIFICIAL.PreCCCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PreCCCommentText), "[0]-" + ARTIFICIAL.PreCCCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PostCCCannedCommentGuid), "[0]-" + ARTIFICIAL.PostCCCannedCommentGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PostCCCommentText), "[0]-" + ARTIFICIAL.PostCCCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FinalizeCannedCommentGuid), "[0]-" + ARTIFICIAL.FinalizeCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FinalizeCommentText), "[0]-" + ARTIFICIAL.FinalizeCommentText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PartialSaveId), "[0]-" + TABLES.PatientTransfusionReaction.PartialSaveId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.DivisionCode), "[0]-" + TABLES.PatientTransfusionReaction.DivisionCode);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), "[0]-" + TABLES.VamcDivision.DivisionName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.RecordStatusCode), "[0]-" + TABLES.PatientTransfusionReaction.RecordStatusCode);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.CompletedBy), "[0]-" + ARTIFICIAL.CompletedBy);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.CompletedDateTime), "[0]-" + ARTIFICIAL.CompletedDateTime);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.FinalizedBy), "[0]-" + ARTIFICIAL.FinalizedBy);

			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.FinalizedDateTime), "[0]-" + ARTIFICIAL.FinalizedDateTime);

			//Next table-----------------------------
			dtTest = dsTest.Tables[1];
			Assert.AreEqual(9, dtTest.Columns.Count, "[1]-Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReactionSymptom.PatientTransfusionReactionGuid), "[1]-" + TABLES.TransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReactionSymptom.PatientSymptomId), "[1]-" + TABLES.PatientTransfusionReactionSymptom.PatientSymptomId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSymptom.PatientSymptomName), "[1]-" + TABLES.PatientSymptom.PatientSymptomName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.CannedCommentGuid), "[1]-" + TABLES.PatientTransfusionComment.CannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionCommentText), "[1]-" + TABLES.PatientTransfusionComment.PatientTransfusionCommentText);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReactionSymptom.LastUpdateDate), "[1]-" + TABLES.PatientTransfusionReactionSymptom.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReactionSymptom.LastUpdateUser), "[1]-" + TABLES.PatientTransfusionReactionSymptom.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionCode), "[1]-" + TABLES.VamcDivision.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), "[1]-" + TABLES.VamcDivision.DivisionName);


			//Next table----------------------------
			dtTest = dsTest.Tables[2];
			Assert.AreEqual(17, dtTest.Columns.Count, "[2]-Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReactionSymptom.PatientTransfusionReactionGuid), "[2]-" + TABLES.TransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), "[2]-" + TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), "[2]-" + TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), "[2]-" + TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), "[2]-" + ARTIFICIAL.PooledUnitsCount);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReaction.BagHemolysisInspectionCode), "[2]-" + TABLES.TransfusionReaction.BagHemolysisInspectionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.HemolysisInspection.HemolysisInspectionText), "[2]-" + TABLES.HemolysisInspection.HemolysisInspectionText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReaction.BagReturnedIndicator), "[2]-" + TABLES.TransfusionReaction.BagReturnedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReaction.BagClericalChecksOkIndicator), "[2]-" + TABLES.TransfusionReaction.BagClericalChecksOkIndicator);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.BagCannedCommentGuid), "[2]-" + ARTIFICIAL.BagCannedCommentGuid);

			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.BagCommentText), "[2]-" + ARTIFICIAL.BagCommentText);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.CheckCannedCommentGuid), "[2]-" + ARTIFICIAL.CheckCannedCommentGuid);
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.CheckCommentText), "[2]-" + ARTIFICIAL.CheckCommentText);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.TransfusionReaction.LastUpdateDate), "[2]-" + TABLES.TransfusionReaction.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReaction.LastUpdateDate), "[2]-" + TABLES.TransfusionReaction.LastUpdateUser);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionCode), "[2]-" + TABLES.VamcDivision.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), "[2]-" + TABLES.VamcDivision.DivisionName);

			//Next table-----------------------------
			dtTest = dsTest.Tables[3];
			Assert.AreEqual(32, dtTest.Columns.Count, "[3]-Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReactionSymptom.PatientTransfusionReactionGuid), "[3]-" + TABLES.TransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.TestGuid), "[3]-" + ARTIFICIAL.TestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.OrderedTestGuid), "[3]-" + TABLES.OrderedTest.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestId), "[3]-" + TABLES.OrderableTest.OrderableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.ReportableTestId), "[3]-" + TABLES.BloodTestType.ReportableTestId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestText), "[3]-" + TABLES.OrderableTest.OrderableTestText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.BloodTestTypeId), "[3]-" + TABLES.SpecimenTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), "[3]-" + TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), "[3]-" + TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), "[3]-" + TABLES.BloodUnit.EyeReadableUnitId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), "[3]-" + TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PooledUnitsCount), "[3]-" + ARTIFICIAL.PooledUnitsCount);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), "[3]-" + TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestTechId), "[3]-" + TABLES.SpecimenTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.EntryTechId), "[3]-" + TABLES.SpecimenTest.EntryTechId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestDate), "[3]-" + TABLES.SpecimenTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.IssuedUnitComment.EntryDate), "[3]-" + TABLES.IssuedUnitComment.EntryDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), "[3]-" + TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.AutoInstrumentName), "[3]-" + TABLES.SpecimenTest.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.CannedCommentGuid), "[3]-" + TABLES.SpecimenTest.CannedCommentGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestComments), "[3]-" + TABLES.SpecimenTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.PatientSpecimenGuid), "[3]-" + TABLES.SpecimenTest.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.SpecimenUid), "[3]-" + TABLES.PatientSpecimen.SpecimenUid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenGuid), "[3]-" + TABLES.PatientTransfusionReaction.PreSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.PreSpecimenUid), "[3]-" + ARTIFICIAL.PreSpecimenUid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.RecordStatusCode), "[3]-" + TABLES.SpecimenTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.LastUpdateUser), "[3]-" + TABLES.SpecimenTest.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.LastUpdateDate), "[3]-" + TABLES.SpecimenTest.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.InactivateUser), "[3]-" + TABLES.SpecimenTest.InactivateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.InactivateDate), "[3]-" + TABLES.SpecimenTest.InactivateDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionCode), "[3]-" + TABLES.VamcDivision.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), "[3]-" + TABLES.VamcDivision.DivisionName);

		}

		[Test]
		public void GetPatientTransfusionReactionReport_Fail()
		{
			DataSet dsTest = DAL.PatientTransfusionReaction.GetPatientTransfusionReactionReport(Guid.NewGuid());

			Assert.AreEqual(4, dsTest.Tables.Count, "Tables.Count");

			Assert.AreEqual(0, dsTest.Tables[0].Rows.Count, "[0]-Rows.Count");
			Assert.AreEqual(0, dsTest.Tables[1].Rows.Count, "[1]-Rows.Count");
			Assert.AreEqual(0, dsTest.Tables[2].Rows.Count, "[2]-Rows.Count");
			Assert.AreEqual(0, dsTest.Tables[3].Rows.Count, "[3]-Rows.Count");
		}

		[Test]
		public void GetSerologicBloodUnitTests_Pass()
		{
			Guid testGuid = (Guid)this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];

			DataTable dtTest = DAL.PatientTransfusionReaction.GetSerologicBloodUnitTests(testGuid, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(26, dtTest.Columns.Count, "Columns.Count");			

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.OrderedTestGuid), TABLES.BloodUnitTest.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitTestGuid), TABLES.BloodUnitTest.BloodUnitTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodUnitGuid), TABLES.BloodUnitTest.BloodUnitGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestingMethodCode), TABLES.BloodUnitTest.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RackGuid), TABLES.BloodUnitTest.RackGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.TestedWith), TABLES.BloodTestType.TestedWith);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.BloodTestTypeId), TABLES.BloodUnitTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.Phase), TABLES.BloodTestType.Phase);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.SortColumn), TABLES.BloodTestType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestResultId), TABLES.BloodUnitTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestTechId), TABLES.BloodUnitTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestDate), TABLES.BloodUnitTest.TestDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.TestComments), TABLES.BloodUnitTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.AutoInstrumentName), TABLES.BloodUnitTest.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RecordStatusCode), TABLES.BloodUnitTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.InactivateUser), TABLES.BloodUnitTest.InactivateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.InactivateDate), TABLES.BloodUnitTest.InactivateDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitTest.RowVersion), TABLES.BloodUnitTest.RowVersion);
		}

		[Test]
		public void GetSerologicBloodUnitTests_Fail()
		{
			try		//TestGuid
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetSerologicBloodUnitTests(Guid.Empty, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, "1-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try		//DivisionCode
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetSerologicBloodUnitTests(Guid.NewGuid(), string.Empty);
				Assert.IsTrue(false, "2-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetSerologicSpecimenTests_Pass()
		{
			Guid testGuid = (Guid)this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];

			DataTable dtTest = DAL.PatientTransfusionReaction.GetSerologicSpecimenTests(testGuid, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(27, dtTest.Columns.Count, "Columns.Count");			

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSpecimen.PatientSpecimenGuid), TABLES.PatientSpecimen.PatientSpecimenGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.OrderedTestGuid), TABLES.SpecimenTest.OrderedTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.SpecimenTestGuid), TABLES.SpecimenTest.SpecimenTestGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderedTest.PatientOrderGuid), TABLES.OrderedTest.PatientOrderGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.ReportableTestId), TABLES.BloodTestType.ReportableTestId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.OrderableTest.OrderableTestText), TABLES.OrderableTest.OrderableTestText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestingMethodCode), TABLES.SpecimenTest.TestingMethodCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestingMethod.TestingMethodText), TABLES.TestingMethod.TestingMethodText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.RackGuid), TABLES.SpecimenTest.RackGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Rack.RackName), TABLES.Rack.RackName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.TestedWith), TABLES.BloodTestType.TestedWith);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.BloodTestTypeId), TABLES.SpecimenTest.BloodTestTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.BloodTestName), TABLES.BloodTestType.BloodTestName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.Phase), TABLES.BloodTestType.Phase);
		
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodTestType.SortColumn), TABLES.BloodTestType.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestResultId), TABLES.SpecimenTest.TestResultId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TestResult.TestResultText), TABLES.TestResult.TestResultText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.AntibodyTypeId), TABLES.SpecimenTest.AntibodyTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.AntibodyType.AntibodyTypeName), TABLES.AntibodyType.AntibodyTypeName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestTechId), TABLES.SpecimenTest.TestTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestDate), TABLES.SpecimenTest.TestDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.TestComments), TABLES.SpecimenTest.TestComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.AutoInstrumentName), TABLES.SpecimenTest.AutoInstrumentName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.AutoInstrumentQCIndicator), TABLES.SpecimenTest.AutoInstrumentQCIndicator);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.RecordStatusCode), TABLES.SpecimenTest.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.SpecimenTest.RowVersion), TABLES.SpecimenTest.RowVersion);
		}

		[Test]
		public void GetSerologicSpecimenTests_Fail()
		{
			try		//TestGuid
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetSerologicSpecimenTests(Guid.Empty, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, "1-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try		//DivisionCode
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetSerologicSpecimenTests(Guid.NewGuid(), string.Empty);
				Assert.IsTrue(false, "2-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetSymtoms_Pass()
		{
			Guid transfusionGuid = (Guid)this._dtPatient.Rows[0][TABLES.Patient.PatientGuid];

			DataTable dtTest = DAL.PatientTransfusionReaction.GetSymtoms(transfusionGuid, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(2, dtTest.Columns.Count, "Columns.Count");	
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSymptom.PatientSymptomId), TABLES.PatientSymptom.PatientSymptomId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSymptom.PatientSymptomName), TABLES.PatientSymptom.PatientSymptomName);
		}

		[Test]
		public void GetSymtoms_Fail()
		{
			try		//TestGuid
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetSymtoms(Guid.Empty, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, "1-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try		//DivisionCode
			{
				DataTable dtTest = DAL.PatientTransfusionReaction.GetSymtoms(Guid.NewGuid(), string.Empty);
				Assert.IsTrue(false, "2-" + AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetPatientSymptomList_Pass()
		{
			DataTable dtTest = DAL.PatientTransfusionReaction.GetPatientSymptomList();

			Assert.AreEqual(3, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSymptom.PatientSymptomId), TABLES.PatientSymptom.PatientSymptomId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSymptom.PatientSymptomName), TABLES.PatientSymptom.PatientSymptomName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientSymptom.SortColumn), TABLES.PatientSymptom.SortColumn);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetPatientSymptomList_Fail()
		{		
		}

		[Test]
		public void GetTransfusionReactionsForPatient_Pass()
		{
			Guid patientGuid = (Guid)this._dtGuids.Rows[0][TABLES.PatientTransfusionReaction.PatientGuid];

			DataTable dtTest = DAL.PatientTransfusionReaction.GetTransfusionReactionsForPatient(patientGuid);

			Assert.AreEqual(19, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientGuid), TABLES.PatientTransfusionReaction.PatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.BloodTypeCode), TABLES.Patient.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.RhFactorCode), TABLES.Patient.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode), TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), TABLES.TransfusionReactionType.TransfusionReactionTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.NotedDateTime), TABLES.PatientTransfusionReaction.NotedDateTime);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.InvestigatedDateTime), TABLES.PatientTransfusionReaction.InvestigatedDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.EntryTechId), TABLES.PatientTransfusionReaction.EntryTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.EntryDateTime), TABLES.PatientTransfusionReaction.EntryDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.MedicalDirectorName), TABLES.PatientTransfusionReaction.MedicalDirectorName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.OrderedTestGuid), TABLES.PatientTransfusionReaction.OrderedTestGuid);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator), TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator), TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.RecordStatusCode), TABLES.PatientTransfusionReaction.RecordStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.DivisionCode), TABLES.PatientTransfusionReaction.DivisionCode);		
		}

		[Test]
		public void GetTransfusionReactionsForPatient_Fail()
		{
			DataTable dt = DAL.PatientTransfusionReaction.GetTransfusionReactionsForPatient(Guid.Empty);
			Assert.AreEqual(0, dt.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetTransfusionReactionsForPatientCount_Pass()
		{
			Assert.IsTrue(DAL.PatientTransfusionReaction.GetTransfusionReactionsForPatientCount((Guid)this._dtGuids.Rows[0][TABLES.PatientTransfusionReaction.PatientGuid]) >= 0);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetTransfusionReactionsForPatientCount_Fail()
		{
			Assert.IsTrue(DAL.PatientTransfusionReaction.GetTransfusionReactionsForPatientCount(Guid.Empty) == 0);
		}

		[Test]
		public void GetTransfusionReactionRecords_Pass()
		{
			Guid transfusionGuid = (Guid)this._dtGuids.Rows[0][TABLES.PatientTransfusionReaction.PatientGuid];

			DataTable dt = DAL.PatientTransfusionReaction.GetTransfusionReactionRecords(transfusionGuid);
			
			Assert.AreEqual(10, dt.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dt.Columns.Contains(TABLES.TransfusionReaction.TransfusionReactionGuid), TABLES.TransfusionReaction.TransfusionReactionGuid);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.PatientTransfusion.PatientTransfusionGuid), TABLES.PatientTransfusion.PatientTransfusionGuid);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.TransfusionReaction.BagHemolysisInspectionCode), TABLES.TransfusionReaction.BagHemolysisInspectionCode);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.TransfusionReaction.BagReturnedIndicator), TABLES.TransfusionReaction.BagReturnedIndicator);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.TransfusionReaction.BagClericalChecksOkIndicator), TABLES.TransfusionReaction.BagClericalChecksOkIndicator);

			Assert.AreEqual(true, dt.Columns.Contains(TABLES.TransfusionReaction.TagNotScannedIndicator), TABLES.TransfusionReaction.TagNotScannedIndicator);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.TransfusionReaction.LastUpdateDate), TABLES.TransfusionReaction.LastUpdateDate);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.TransfusionReaction.LastUpdateUser), TABLES.TransfusionReaction.LastUpdateUser);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.TransfusionReaction.LastUpdateFunctionId), TABLES.TransfusionReaction.LastUpdateFunctionId);
			Assert.AreEqual(true, dt.Columns.Contains(TABLES.TransfusionReaction.RowVersion), TABLES.TransfusionReaction.RowVersion);
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetTransfusionReactionRecords_Fail()
		{
			DataTable dt = DAL.PatientTransfusionReaction.GetTransfusionReactionRecords(Guid.Empty);
		}

		[Test]
		public void Invalidate_Guid_Pass()
		{
			this.RefreshData = true;

			DataTable dtTest=this.GetDataForOrderedTest();

			if (dtTest.Rows[0].IsNull(TABLES.OrderedTest.TaskStatusCode))
				dtTest.Rows[0][TABLES.OrderedTest.TaskStatusCode] = Common.Utility.GetTaskStatusCodeFromEnum(Common.TaskStatus.InProgress);

			Guid ptrGuid = (Guid)this._dtPTR.Rows[0][TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid];
			byte[] rowVersion = (byte[])this._dtPTR.Rows[0][TABLES.PatientTransfusionReaction.RowVersion];

			DataTable dtCopy = dtTest.Copy();

			foreach (DataColumn dc in dtTest.Columns)
			{
				if (dc.ColumnName != TABLES.OrderedTest.OrderedTestGuid &&
					dc.ColumnName != TABLES.OrderedTest.TaskStatusCode &&
					dc.ColumnName != TABLES.OrderedTest.OrderStatusCode &&
					dc.ColumnName != TABLES.OrderedTest.LastUpdateUser &&
					dc.ColumnName != TABLES.OrderedTest.LastUpdateFunctionId &&
					dc.ColumnName != TABLES.OrderedTest.RowVersion &&
					dc.ColumnName != TABLES.OrderedTest.LastUpdateDate)
				{
					dtCopy.Columns.Remove(dc.ColumnName);
				}
			}
					
			bool retValue = DAL.PatientTransfusionReaction.Invalidate(ptrGuid, dtCopy, rowVersion); 
			
			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void Invalidate_Guid_Fail()
		{
			this.RefreshData = true;

			Guid ptrGuid = (Guid)this._dtPTR.Rows[0][TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid];
			byte[] rowVersion = new byte[8];

			DAL.PatientTransfusionReaction.Invalidate(ptrGuid, _setUpData.Table,rowVersion); 
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Invalidate_EmptyGuid_Fail()
		{
			this.RefreshData = true;

			Guid ptrGuid = Guid.Empty;
			byte[] rowVersion = (byte[])this._dtPTR.Rows[0][TABLES.PatientTransfusionReaction.RowVersion];

			DAL.PatientTransfusionReaction.Invalidate(ptrGuid, _setUpData.Table,rowVersion); 
		}

		[Test]
		public void Invalidate_4DTs_Pass()
		{
			this.RefreshData = true;

            DataTable dtPTR = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 PTR.* FROM PatientTransfusionReaction PTR JOIN OrderedTest OT ON PTR.OrderedTestGuid = OT.OrderedTestGuid WHERE OT.PatientSpecimenGuid IS NOT NULL AND PTR.DivisionCode = '" + this.TestDivisionCode + "' ORDER BY PTR.LastUpdateDate DESC");
			
			//Create a bloodunittest for the OrderedTest
			BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(false);
			Guid newbutGuid = Guid.NewGuid();
			Guid otGuid = (Guid)dtPTR.Rows[0][TABLES.PatientTransfusionReaction.OrderedTestGuid];
			DataTable dtNewBT = SprocHelper.GetInsertBloodUnitTestSprocTable(newbutGuid, tmpUnit.BloodUnitGuid, 103, "P");
			new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertBloodUnitTest.StoredProcName, dtNewBT);
			UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET OrderedTestGuid = '" + dtPTR.Rows[0][TABLES.PatientTransfusionReaction.OrderedTestGuid].ToString() + "' WHERE BloodUnitTestGuid = '" + newbutGuid.ToString() + "'");
            
			//Create a Specimen Test
			Guid psGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientSpecimenGuid FROM OrderedTest WHERE OrderedTestGuid = '" + otGuid.ToString() + "'");
			Guid newSTGuid = Guid.NewGuid();
			DataTable dtNewST = SprocHelper.GetInsertSpecimenTestSprocTable(newSTGuid, otGuid, psGuid, 103);
			new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertSpecimenTest.StoredProcName, dtNewST);

			DataTable dtBUT = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM BloodUnitTest WHERE BloodUnitTestGuid = '" + newbutGuid.ToString() + "'");
			Guid butGuid = (Guid)dtBUT.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			byte[] butRowVersion = (byte[])dtBUT.Rows[0][TABLES.BloodUnitTest.RowVersion];

			DataTable dtST = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM SpecimenTest WHERE SpecimenTestGuid = '" + newSTGuid.ToString() + "'");
			Guid stGuid = (Guid)dtST.Rows[0][TABLES.SpecimenTest.SpecimenTestGuid];
			byte[] specRowVersion = (byte[])dtST.Rows[0][TABLES.SpecimenTest.RowVersion];

			Guid ptrGuid = (Guid)dtPTR.Rows[0][TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid];
			byte[] ptrRowVersion = (byte[])dtPTR.Rows[0][TABLES.PatientTransfusionReaction.RowVersion];

			DataTable dtInvalidatePTR = SprocHelper.GetInvalidateTransfusionReactionWorkupSprocTable(ptrGuid, ptrRowVersion);
			DataTable dtUpdateSTS = SprocHelper.GetUpdateSpecimenTestStatusSprocTable(stGuid, specRowVersion);
			DataTable dtUpdateBUT = SprocHelper.GetUpdateBloodUnitTestRecordStatusSprocTable(butGuid, butRowVersion);
			DataTable dtUpdateOT = new DataTable();

			Guid[] workloadGuids = {butGuid};
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			DataTable dtWorkload = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.TransfusionReactionInvestigation, workloadGuids, Common.WorkloadTransactionType.Patient, true);

			bool retValue = DAL.PatientTransfusionReaction.Invalidate(dtInvalidatePTR, dtUpdateBUT, dtUpdateSTS, dtUpdateOT, new DataTable(),Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnValue");

			//Clean up this crap, cuz it might be bad data
			UnitTestUtil.RunSQL("DELETE FROM BloodUnitTest WHERE BloodUnitTestGuid = '" + newbutGuid.ToString() + "'");
			UnitTestUtil.RunSQL("DELETE FROM SpecimenTest WHERE SpecimenTestGuid = '" + newSTGuid.ToString() + "'");
		}

		[Test]
		public void Invalidate_4DTs_Fail()
		{
			this.RefreshData = true;

            DataTable dtPTR = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 PTR.* FROM PatientTransfusionReaction PTR JOIN OrderedTest OT ON PTR.OrderedTestGuid = OT.OrderedTestGuid WHERE OT.PatientSpecimenGuid IS NOT NULL AND PTR.DivisionCode = '" + this.TestDivisionCode + "' ORDER BY PTR.LastUpdateDate DESC");
			
			//Create a bloodunittest for the OrderedTest
			BOL.BloodUnit tmpUnit = DataCreator.CreateBloodUnit(false);
			Guid newbutGuid = Guid.NewGuid();
			Guid otGuid = (Guid)dtPTR.Rows[0][TABLES.PatientTransfusionReaction.OrderedTestGuid];
			DataTable dtNewBT = SprocHelper.GetInsertBloodUnitTestSprocTable(newbutGuid, tmpUnit.BloodUnitGuid, 103, "P");
			new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertBloodUnitTest.StoredProcName, dtNewBT);
			UnitTestUtil.RunSQL("UPDATE BloodUnitTest SET OrderedTestGuid = '" + dtPTR.Rows[0][TABLES.PatientTransfusionReaction.OrderedTestGuid].ToString() + "' WHERE BloodUnitTestGuid = '" + newbutGuid.ToString() + "'");
            
			//Create a Specimen Test
			Guid psGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientSpecimenGuid FROM OrderedTest WHERE OrderedTestGuid = '" + otGuid.ToString() + "'");
			Guid newSTGuid = Guid.NewGuid();
			DataTable dtNewST = SprocHelper.GetInsertSpecimenTestSprocTable(newSTGuid, otGuid, psGuid, 103);
			new Common.StoredProcedure().TransactionalGetValue(SPROCS.InsertSpecimenTest.StoredProcName, dtNewST);

			DataTable dtBUT = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM BloodUnitTest WHERE BloodUnitTestGuid = '" + newbutGuid.ToString() + "'");
			Guid butGuid = (Guid)dtBUT.Rows[0][TABLES.BloodUnitTest.BloodUnitTestGuid];
			byte[] butRowVersion =  new byte[8];

			DataTable dtST = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM SpecimenTest WHERE SpecimenTestGuid = '" + newSTGuid.ToString() + "'");
			Guid stGuid = (Guid)dtST.Rows[0][TABLES.SpecimenTest.SpecimenTestGuid];
			byte[] stRowVersion =  new byte[8];

			Guid ptrGuid = (Guid)dtPTR.Rows[0][TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid];
			byte[] ptrRowVersion = new byte[8];

			DataTable dtInvalidatePTR = SprocHelper.GetInvalidateTransfusionReactionWorkupSprocTable(ptrGuid, ptrRowVersion);
			DataTable dtUpdateSTS = SprocHelper.GetUpdateSpecimenTestStatusSprocTable(stGuid, stRowVersion);
			DataTable dtUpdateBUT = SprocHelper.GetUpdateBloodUnitTestRecordStatusSprocTable(butGuid, butRowVersion);
			DataTable dtUpdateOT = new DataTable();

			bool yarrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrg = false;

			try
			{DAL.PatientTransfusionReaction.Invalidate(dtInvalidatePTR, dtUpdateBUT, dtUpdateSTS, dtUpdateOT, new DataTable(),Common.UpdateFunction.UnitTests);}
			catch(Common.RowVersionException)
			{
				yarrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrg = true;
				//Clean up this crap, cuz it might be bad data
				UnitTestUtil.RunSQL("DELETE FROM BloodUnitTest WHERE BloodUnitTestGuid = '" + newbutGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM SpecimenTest WHERE SpecimenTestGuid = '" + newSTGuid.ToString() + "'");
			}
			finally
			{
				Assert.AreEqual(true, yarrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrg, "RowVersion Expected");
			}
			
		}

		[Test]
		public void SaveImplicatedBloodUnits_Pass()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodUnitGuid = Guid.NewGuid();
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

			//Now we can enter specimen phase of a TRW...
			BOL.PatientTransfusionReaction ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			BOL.OrderedTest orderedTest = new BOL.OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			//
			ptr.SaveSpecimenCheckData(orderedTest, new System.Collections.ArrayList(), null);
			ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			//
			// For this test, we'll implicate the unit we transfused earlier...
			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PartialSaveId, typeof(byte));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RowVersion, typeof(byte []));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));

			DataRow drPatientTransfusionReaction = dtPatientTransfusionReaction.NewRow();
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PartialSaveId] = 2;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.RowVersion] = ptr.RowVersion;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dtPatientTransfusionReaction.Rows.Add(drPatientTransfusionReaction);
			// ****************************************************************************************************************************
			DataTable dtTransfusionReaction = new DataTable();
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.TransfusionReactionGuid, typeof(Guid));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.PatientTransfusionGuid, typeof(Guid));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.BagReturnedIndicator, typeof(bool));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.BagHemolysisInspectionCode, typeof(string));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.BagClericalChecksOkIndicator, typeof(bool));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.TagNotScannedIndicator, typeof(bool));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.LastUpdateUser, typeof(string));

			DataRow drTransfusionReaction = dtTransfusionReaction.NewRow();
			drTransfusionReaction[TABLES.TransfusionReaction.TransfusionReactionGuid] = Guid.NewGuid();
			drTransfusionReaction[TABLES.TransfusionReaction.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drTransfusionReaction[TABLES.TransfusionReaction.PatientTransfusionGuid] = patientTransfusionGuid;
			drTransfusionReaction[TABLES.TransfusionReaction.BagReturnedIndicator] = true;
			drTransfusionReaction[TABLES.TransfusionReaction.BagHemolysisInspectionCode] = "1";
			drTransfusionReaction[TABLES.TransfusionReaction.BagClericalChecksOkIndicator] = true;
			drTransfusionReaction[TABLES.TransfusionReaction.TagNotScannedIndicator] = false;
			drTransfusionReaction[TABLES.TransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtTransfusionReaction.Rows.Add(drTransfusionReaction);
			// ****************************************************************************************************************************
			DataTable dtPatientTransfusionComment = new DataTable();
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.CommentCategoryCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionCommentText, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.DivisionCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.RecordStatusCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.LastUpdateUser, typeof(string));

			DataRow drImplicatedUnitComment = dtPatientTransfusionComment.NewRow();
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid] = Guid.NewGuid();
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.PatientTransfusionGuid] = patientTransfusionGuid;
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.CommentCategoryCode] = "T3";
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.PatientTransfusionCommentText] = "TESTING " + DateTime.Now;
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.RecordStatusCode] = "A";
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtPatientTransfusionComment.Rows.Add(drImplicatedUnitComment);

			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Transfusion_Reaction_Workup, "Unit Test 4644", Environment.UserName);
			exRep.GenerateExceptionTrwUnitClericalCheckFailed(ptr,new BOL.Patient(patientGuid), new BOL.BloodUnit(bloodUnitGuid),new BOL.TransfusionReaction(drTransfusionReaction));
			DataTable unitClericalCheckExceptions = exRep.ExceptionData.Table.Clone();
			unitClericalCheckExceptions.Rows.Add(exRep.ExceptionData.ItemArray);

			bool success = DAL.PatientTransfusionReaction.SaveImplicatedBloodUnits (dtPatientTransfusionReaction, dtTransfusionReaction, dtPatientTransfusionComment, unitClericalCheckExceptions, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, success, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void SaveImplicatedBloodUnits_Fail()
		{
			this.RefreshData = true;
			// Get transfused units for our patient
			DataTable units = DAL.PatientTransfusion.GetTransfusedUnitsForPatient((Guid)this._existingData["PatientGuid"], Common.LogonUser.LogonUserDivisionCode);

			Assert.IsTrue(units.Rows.Count > 0, "No transfused units found for PatientGuid: " + _setUpData["PatientGuid"].ToString());

			// Grab the first one
			// Note: BloodUnitGuid and UnitProductCode are also available through this method
			Guid patientTransfusionGuid = (Guid)units.Rows[0]["PatientTransfusionGuid"];

			// For this test, we'll implicate the unit we got in SetUp()
			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PartialSaveId, typeof(byte));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RowVersion, typeof(byte []));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));

			DataRow drPatientTransfusionReaction = dtPatientTransfusionReaction.NewRow();
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PartialSaveId] = 2;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.RowVersion] = this._existingData["RowVersion"];
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dtPatientTransfusionReaction.Rows.Add(drPatientTransfusionReaction);
			// ****************************************************************************************************************************
			DataTable dtTransfusionReaction = new DataTable();
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.PatientTransfusionGuid, typeof(Guid));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.BagReturnedIndicator, typeof(bool));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.BagHemolysisInspectionCode, typeof(string));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.BagClericalChecksOkIndicator, typeof(bool));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.TagNotScannedIndicator, typeof(bool));
			dtTransfusionReaction.Columns.Add(TABLES.TransfusionReaction.LastUpdateUser, typeof(string));

			DataRow drTransfusionReaction = dtTransfusionReaction.NewRow();
			drTransfusionReaction[TABLES.TransfusionReaction.PatientTransfusionGuid] = patientTransfusionGuid;
			drTransfusionReaction[TABLES.TransfusionReaction.BagReturnedIndicator] = true;
			drTransfusionReaction[TABLES.TransfusionReaction.BagHemolysisInspectionCode] = "1";
			drTransfusionReaction[TABLES.TransfusionReaction.BagClericalChecksOkIndicator] = true;
			drTransfusionReaction[TABLES.TransfusionReaction.TagNotScannedIndicator] = false;
			drTransfusionReaction[TABLES.TransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtTransfusionReaction.Rows.Add(drTransfusionReaction);
			// ****************************************************************************************************************************
			DataTable dtPatientTransfusionComment = new DataTable();
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.CommentCategoryCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionCommentText, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.DivisionCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.RecordStatusCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.LastUpdateUser, typeof(string));

			DataRow drImplicatedUnitComment = dtPatientTransfusionComment.NewRow();
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.PatientTransfusionGuid] = patientTransfusionGuid;
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.CommentCategoryCode] = "T3";
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.PatientTransfusionCommentText] = "TESTING " + DateTime.Now;
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.RecordStatusCode] = "A";
			drImplicatedUnitComment[TABLES.PatientTransfusionComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtPatientTransfusionComment.Rows.Add(drImplicatedUnitComment);

			bool success = DAL.PatientTransfusionReaction.SaveImplicatedBloodUnits (dtPatientTransfusionReaction, dtTransfusionReaction, dtPatientTransfusionComment, null, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, success, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void SaveImplicatedBloodUnits_EmptyTable_Fail()
		{
			bool success = DAL.PatientTransfusionReaction.SaveImplicatedBloodUnits (new DataTable(), new DataTable(), new DataTable(), null, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(false, success, "ReturnValue");
		}

		[Test]
		public void SaveSerologicTests_Pass()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			Guid bloodUnitGuid = Guid.NewGuid();
			Guid bloodProductGuid = (Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), patientGuid, bloodProductGuid, isCodabar);

			//Insert an RBCx2 order and a TRW order, then transfuse 1 unit...
			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid orderedComponentGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid orderedUnitGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Guid bloodUnitTestGuid1 = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid1, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 100, "0");

			Guid bloodUnitTestGuid2 = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertBloodUnitTest(bloodUnitTestGuid2, bloodUnitGuid, orderedComponentGuid, orderedUnitGuid, 102, "C");

			Guid issuedUnitGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertIssuedUnit(issuedUnitGuid, bloodUnitGuid);

			Guid patientTransfusionGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientTransfusion(patientTransfusionGuid, patientGuid, bloodUnitGuid);

			//			this.UpdateBloodUnitStatus(bloodUnitGuid, Common.UnitStatusCode.Transfused);
			//
			//Now we can enter all phases of a TRW...
			System.Collections.ArrayList bloodUnitTests = new System.Collections.ArrayList();
			System.Collections.ArrayList postSpecimenTests = new System.Collections.ArrayList();
			System.Collections.ArrayList preSpecimenTests = new System.Collections.ArrayList();

			BOL.PatientTransfusionReaction ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			BOL.OrderedTest orderedTest = new BOL.OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			System.Collections.ArrayList specimens = new System.Collections.ArrayList(2);
			specimens.Add(preSpecimen);
			specimens.Add(postSpecimen);
			//
			ptr.SaveSpecimenCheckData(orderedTest, new System.Collections.ArrayList(), null);
			//
			ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			BOL.TransfusionReaction transfusionReaction = new BOL.TransfusionReaction();
			transfusionReaction.BagClericalChecksOkIndicator = true;
			transfusionReaction.BagHemolysisInspectionCode = "1";
			transfusionReaction.BagReturnedIndicator = true;
			transfusionReaction.PatientTransfusionGuid = patientTransfusionGuid;
			transfusionReaction.PatientTransfusionReactionGuid = ptr.PatientTransfusionReactionGuid;
			transfusionReaction.TransfusionReactionGuid = Guid.NewGuid();
			System.Collections.ArrayList transfusionReactions = new System.Collections.ArrayList(1);
			transfusionReactions.Add(transfusionReaction);
			ptr.SaveImplicatedBloodUnits(transfusionReactions, new System.Collections.ArrayList(), null);
			//
			ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			System.Collections.ArrayList allSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			System.Collections.ArrayList symptoms = new System.Collections.ArrayList(1);
			symptoms.Add(allSymptoms[0]);
			ptr.SaveSymptoms(symptoms, null);
			//
			ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			orderedTest = new BOL.OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			DataTable dtRack = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 RackGuid FROM Rack");
			Guid rackGuid = (Guid)dtRack.Rows[0]["RackGuid"];

			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PartialSaveId, typeof(byte));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RowVersion, typeof(byte []));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));

			DataRow drPatientTransfusionReaction = dtPatientTransfusionReaction.NewRow();
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PartialSaveId] = 4;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.RowVersion] = ptr.RowVersion;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dtPatientTransfusionReaction.Rows.Add(drPatientTransfusionReaction);
			
			// ****************************************************************************************************************************
			// We'll insert a test for all four types:
			// ----------------------------------------------------------------------------
			// (1) ABO/Rh
			//		Pre-Transfusion ABO + Rh Interp
			//		Blood Unit ABO + Rh Interp
			// (2) ABS
			//		Pre- and Post- Interp
			// (3) XM
			//		Pre- and Post- Blood Unit Interp
			// (4) DAT
			//		Pre- and Post- Interp
			// ----------------------------------------------------------------------------
			// Reference:
			//
			//			BloodTestTypeId BloodTestName                       OrderableTestId 
			//			--------------- ----------------------------------- --------------- 
			//			105             ABO Interp                          10              
			//			106             Rh Interp                           10              
			//			107             Antibody Screen Interp              10              
			//			108             DAT Poly Interp                     10              
			//			109             Xmatch Pre Interp                   10             
			//			110             Xmatch Post Interp                  10                    
			// ----------------------------------------------------------------------------
			//							SPECIMEN TESTS
			// ----------------------------------------------------------------------------
			DataTable dtSpecimenTest = new DataTable();
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.SpecimenTestGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.OrderedTestGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.PatientSpecimenGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.TestTechId, typeof(string));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.TestingMethodCode, typeof(string));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.BloodTestTypeId, typeof(int));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.TestResultId, typeof(string));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.TestDate, typeof(DateTime));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.RackGuid, typeof(Guid));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.AutoInstrumentName, typeof(string));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.DivisionCode, typeof(string));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.LastUpdateUser, typeof(string));
			dtSpecimenTest.Columns.Add(TABLES.SpecimenTest.PatientTransfusionReactionGuid, typeof(Guid));

			// ----------------------------------------------------------------------------
			// pre-transfusion ABO + Rh Interp
				DataRow drPreSpecimenAboTest = dtSpecimenTest.NewRow();
				drPreSpecimenAboTest[TABLES.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
				drPreSpecimenAboTest[TABLES.SpecimenTest.OrderedTestGuid] = orderedTestGuid;
				drPreSpecimenAboTest[TABLES.SpecimenTest.PatientSpecimenGuid] = prePatientSpecimenGuid;
				drPreSpecimenAboTest[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
				drPreSpecimenAboTest[TABLES.SpecimenTest.TestingMethodCode] = "T";
				drPreSpecimenAboTest[TABLES.SpecimenTest.BloodTestTypeId] = 105;
				drPreSpecimenAboTest[TABLES.SpecimenTest.TestResultId] = "A";
				drPreSpecimenAboTest[TABLES.SpecimenTest.TestDate] = DateTime.Now;
				drPreSpecimenAboTest[TABLES.SpecimenTest.RackGuid] = rackGuid;
				drPreSpecimenAboTest[TABLES.SpecimenTest.AutoInstrumentName] = DBNull.Value;
				drPreSpecimenAboTest[TABLES.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				drPreSpecimenAboTest[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
				drPreSpecimenAboTest[TABLES.SpecimenTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;

				dtSpecimenTest.Rows.Add(drPreSpecimenAboTest);

				DataRow drPreSpecimenRhTest = dtSpecimenTest.NewRow();
				drPreSpecimenRhTest[TABLES.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
				drPreSpecimenRhTest[TABLES.SpecimenTest.OrderedTestGuid] = orderedTestGuid;
				drPreSpecimenRhTest[TABLES.SpecimenTest.PatientSpecimenGuid] = prePatientSpecimenGuid;
				drPreSpecimenRhTest[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
				drPreSpecimenRhTest[TABLES.SpecimenTest.TestingMethodCode] = "T";
				drPreSpecimenRhTest[TABLES.SpecimenTest.BloodTestTypeId] = 106;
				drPreSpecimenRhTest[TABLES.SpecimenTest.TestResultId] = "P";
				drPreSpecimenRhTest[TABLES.SpecimenTest.TestDate] = DateTime.Now;
				drPreSpecimenRhTest[TABLES.SpecimenTest.RackGuid] = rackGuid;
				drPreSpecimenRhTest[TABLES.SpecimenTest.AutoInstrumentName] = DBNull.Value;
				drPreSpecimenRhTest[TABLES.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				drPreSpecimenRhTest[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
				drPreSpecimenRhTest[TABLES.SpecimenTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;

				dtSpecimenTest.Rows.Add(drPreSpecimenRhTest);
			// ----------------------------------------------------------------------------
			// post-transfusion ABO + Rh Interp
			DataRow drPostSpecimenAboTest = dtSpecimenTest.NewRow();
			drPostSpecimenAboTest[TABLES.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
			drPostSpecimenAboTest[TABLES.SpecimenTest.OrderedTestGuid] = orderedTestGuid;
			drPostSpecimenAboTest[TABLES.SpecimenTest.PatientSpecimenGuid] = postPatientSpecimenGuid;
			drPostSpecimenAboTest[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
			drPostSpecimenAboTest[TABLES.SpecimenTest.TestingMethodCode] = "T";
			drPostSpecimenAboTest[TABLES.SpecimenTest.BloodTestTypeId] = 105;
			drPostSpecimenAboTest[TABLES.SpecimenTest.TestResultId] = "A";
			drPostSpecimenAboTest[TABLES.SpecimenTest.TestDate] = DateTime.Now;
			drPostSpecimenAboTest[TABLES.SpecimenTest.RackGuid] = rackGuid;
			drPostSpecimenAboTest[TABLES.SpecimenTest.AutoInstrumentName] = DBNull.Value;
			drPostSpecimenAboTest[TABLES.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drPostSpecimenAboTest[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPostSpecimenAboTest[TABLES.SpecimenTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			dtSpecimenTest.Rows.Add(drPostSpecimenAboTest);

			DataRow drPostSpecimenRhTest = dtSpecimenTest.NewRow();
			drPostSpecimenRhTest[TABLES.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
			drPostSpecimenRhTest[TABLES.SpecimenTest.OrderedTestGuid] = orderedTestGuid;
			drPostSpecimenRhTest[TABLES.SpecimenTest.PatientSpecimenGuid] = postPatientSpecimenGuid;
			drPostSpecimenRhTest[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
			drPostSpecimenRhTest[TABLES.SpecimenTest.TestingMethodCode] = "T";
			drPostSpecimenRhTest[TABLES.SpecimenTest.BloodTestTypeId] = 106;
			drPostSpecimenRhTest[TABLES.SpecimenTest.TestResultId] = "P";
			drPostSpecimenRhTest[TABLES.SpecimenTest.TestDate] = DateTime.Now;
			drPostSpecimenRhTest[TABLES.SpecimenTest.RackGuid] = rackGuid;
			drPostSpecimenRhTest[TABLES.SpecimenTest.AutoInstrumentName] = DBNull.Value;
			drPostSpecimenRhTest[TABLES.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drPostSpecimenRhTest[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPostSpecimenRhTest[TABLES.SpecimenTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			dtSpecimenTest.Rows.Add(drPostSpecimenRhTest);
			// ----------------------------------------------------------------------------
			// pre- and post- transfusion ABS Interp
				DataRow drPreSpecimenAbsTest = dtSpecimenTest.NewRow();
				drPreSpecimenAbsTest[TABLES.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
				drPreSpecimenAbsTest[TABLES.SpecimenTest.OrderedTestGuid] = orderedTestGuid;
				drPreSpecimenAbsTest[TABLES.SpecimenTest.PatientSpecimenGuid] = prePatientSpecimenGuid;
				drPreSpecimenAbsTest[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
				drPreSpecimenAbsTest[TABLES.SpecimenTest.TestingMethodCode] = "T";
				drPreSpecimenAbsTest[TABLES.SpecimenTest.BloodTestTypeId] = 107;
				drPreSpecimenAbsTest[TABLES.SpecimenTest.TestResultId] = "A";
				drPreSpecimenAbsTest[TABLES.SpecimenTest.TestDate] = DateTime.Now;
				drPreSpecimenAbsTest[TABLES.SpecimenTest.RackGuid] = rackGuid;
				drPreSpecimenAbsTest[TABLES.SpecimenTest.AutoInstrumentName] = DBNull.Value;
				drPreSpecimenAbsTest[TABLES.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				drPreSpecimenAbsTest[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
				drPreSpecimenAbsTest[TABLES.SpecimenTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
				dtSpecimenTest.Rows.Add(drPreSpecimenAbsTest);
			
			DataRow drPostSpecimenAbsTest = dtSpecimenTest.NewRow();
			drPostSpecimenAbsTest[TABLES.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
			drPostSpecimenAbsTest[TABLES.SpecimenTest.OrderedTestGuid] = orderedTestGuid;
			drPostSpecimenAbsTest[TABLES.SpecimenTest.PatientSpecimenGuid] = postPatientSpecimenGuid;
			drPostSpecimenAbsTest[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
			drPostSpecimenAbsTest[TABLES.SpecimenTest.TestingMethodCode] = "T";
			drPostSpecimenAbsTest[TABLES.SpecimenTest.BloodTestTypeId] = 107;
			drPostSpecimenAbsTest[TABLES.SpecimenTest.TestResultId] = "A";
			drPostSpecimenAbsTest[TABLES.SpecimenTest.TestDate] = DateTime.Now;
			drPostSpecimenAbsTest[TABLES.SpecimenTest.RackGuid] = rackGuid;
			drPostSpecimenAbsTest[TABLES.SpecimenTest.AutoInstrumentName] = DBNull.Value;
			drPostSpecimenAbsTest[TABLES.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drPostSpecimenAbsTest[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPostSpecimenAbsTest[TABLES.SpecimenTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			dtSpecimenTest.Rows.Add(drPostSpecimenAbsTest);
			// ----------------------------------------------------------------------------
			// pre- and post- transfusion DAT Interp
				DataRow drPreSpecimenDatTest = dtSpecimenTest.NewRow();
				drPreSpecimenDatTest[TABLES.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
				drPreSpecimenDatTest[TABLES.SpecimenTest.OrderedTestGuid] = orderedTestGuid;
				drPreSpecimenDatTest[TABLES.SpecimenTest.PatientSpecimenGuid] = prePatientSpecimenGuid;
				drPreSpecimenDatTest[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
				drPreSpecimenDatTest[TABLES.SpecimenTest.TestingMethodCode] = "T";
				drPreSpecimenDatTest[TABLES.SpecimenTest.BloodTestTypeId] = 108;
				drPreSpecimenDatTest[TABLES.SpecimenTest.TestResultId] = "A";
				drPreSpecimenDatTest[TABLES.SpecimenTest.TestDate] = DateTime.Now;
				drPreSpecimenDatTest[TABLES.SpecimenTest.RackGuid] = rackGuid;
				drPreSpecimenDatTest[TABLES.SpecimenTest.AutoInstrumentName] = DBNull.Value;
				drPreSpecimenDatTest[TABLES.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				drPreSpecimenDatTest[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
				drPreSpecimenDatTest[TABLES.SpecimenTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
				dtSpecimenTest.Rows.Add(drPreSpecimenDatTest);
			//
			DataRow drPostSpecimenDatTest = dtSpecimenTest.NewRow();
			drPostSpecimenDatTest[TABLES.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
			drPostSpecimenDatTest[TABLES.SpecimenTest.OrderedTestGuid] = orderedTestGuid;
			drPostSpecimenDatTest[TABLES.SpecimenTest.PatientSpecimenGuid] = postPatientSpecimenGuid;
			drPostSpecimenDatTest[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
			drPostSpecimenDatTest[TABLES.SpecimenTest.TestingMethodCode] = "T";
			drPostSpecimenDatTest[TABLES.SpecimenTest.BloodTestTypeId] = 108;
			drPostSpecimenDatTest[TABLES.SpecimenTest.TestResultId] = "A";
			drPostSpecimenDatTest[TABLES.SpecimenTest.TestDate] = DateTime.Now;
			drPostSpecimenDatTest[TABLES.SpecimenTest.RackGuid] = rackGuid;
			drPostSpecimenDatTest[TABLES.SpecimenTest.AutoInstrumentName] = DBNull.Value;
			drPostSpecimenDatTest[TABLES.SpecimenTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drPostSpecimenDatTest[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPostSpecimenDatTest[TABLES.SpecimenTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			dtSpecimenTest.Rows.Add(drPostSpecimenDatTest);
			// ----------------------------------------------------------------------------
			//							BLOOD UNITS TESTS
			// ----------------------------------------------------------------------------
			DataTable dtBloodUnitTest = new DataTable();
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.BloodUnitGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.BloodTestTypeId, typeof(int));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.TestDate, typeof(DateTime));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.TestResultId, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.EntryMethodCode, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.DivisionCode, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.LastUpdateUser, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.OrderedTestGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.TestingMethodCode, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.TestTechId, typeof(string));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.PatientTransfusionReactionGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.RackGuid, typeof(Guid));
			dtBloodUnitTest.Columns.Add(TABLES.BloodUnitTest.AutoInstrumentName, typeof(string));
			// ----------------------------------------------------------------------------
			// Blood Unit ABO + Rh Interp
			DataRow drBloodUnitAboTest = dtBloodUnitTest.NewRow();
			drBloodUnitAboTest[TABLES.BloodUnitTest.BloodUnitTestGuid] = Guid.NewGuid();
			drBloodUnitAboTest[TABLES.BloodUnitTest.BloodUnitGuid] = bloodUnitGuid;
			drBloodUnitAboTest[TABLES.BloodUnitTest.BloodTestTypeId] = 105;
			drBloodUnitAboTest[TABLES.BloodUnitTest.TestDate] = DateTime.Now;
			drBloodUnitAboTest[TABLES.BloodUnitTest.TestResultId] = "A";
			drBloodUnitAboTest[TABLES.BloodUnitTest.EntryMethodCode] = "M";
			drBloodUnitAboTest[TABLES.BloodUnitTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drBloodUnitAboTest[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drBloodUnitAboTest[TABLES.BloodUnitTest.OrderedTestGuid] = orderedTestGuid;
			drBloodUnitAboTest[TABLES.BloodUnitTest.TestingMethodCode] = "T";
			drBloodUnitAboTest[TABLES.BloodUnitTest.TestTechId] = Common.LogonUser.LogonUserName;
			drBloodUnitAboTest[TABLES.BloodUnitTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drBloodUnitAboTest[TABLES.BloodUnitTest.RackGuid] = rackGuid;
			drBloodUnitAboTest[TABLES.BloodUnitTest.AutoInstrumentName] = DBNull.Value;
			dtBloodUnitTest.Rows.Add(drBloodUnitAboTest);

			DataRow drBloodUnitRhTest = dtBloodUnitTest.NewRow();
			drBloodUnitRhTest[TABLES.BloodUnitTest.BloodUnitTestGuid] = Guid.NewGuid();
			drBloodUnitRhTest[TABLES.BloodUnitTest.BloodUnitGuid] = bloodUnitGuid;
			drBloodUnitRhTest[TABLES.BloodUnitTest.BloodTestTypeId] = 106;
			drBloodUnitRhTest[TABLES.BloodUnitTest.TestDate] = DateTime.Now;
			drBloodUnitRhTest[TABLES.BloodUnitTest.TestResultId] = "P";
			drBloodUnitRhTest[TABLES.BloodUnitTest.EntryMethodCode] = "M";
			drBloodUnitRhTest[TABLES.BloodUnitTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drBloodUnitRhTest[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drBloodUnitRhTest[TABLES.BloodUnitTest.OrderedTestGuid] = orderedTestGuid;
			drBloodUnitRhTest[TABLES.BloodUnitTest.TestingMethodCode] = "T";
			drBloodUnitRhTest[TABLES.BloodUnitTest.TestTechId] = Common.LogonUser.LogonUserName;
			drBloodUnitRhTest[TABLES.BloodUnitTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drBloodUnitRhTest[TABLES.BloodUnitTest.RackGuid] = rackGuid;
			drBloodUnitRhTest[TABLES.BloodUnitTest.AutoInstrumentName] = DBNull.Value;
			dtBloodUnitTest.Rows.Add(drBloodUnitRhTest);
			// ----------------------------------------------------------------------------
			// Blood Unit Xmatch Pre- and Post- Interp
			DataRow drBloodUnitPreXmatchTest = dtBloodUnitTest.NewRow();
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.BloodUnitTestGuid] = Guid.NewGuid();
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.BloodUnitGuid] = bloodUnitGuid;
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.BloodTestTypeId] = 109;
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.TestDate] = DateTime.Now;
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.TestResultId] = "P";
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.EntryMethodCode] = "M";
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.OrderedTestGuid] = orderedTestGuid;
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.TestingMethodCode] = "T";
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.TestTechId] = Common.LogonUser.LogonUserName;
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.RackGuid] = rackGuid;
			drBloodUnitPreXmatchTest[TABLES.BloodUnitTest.AutoInstrumentName] = DBNull.Value;
			dtBloodUnitTest.Rows.Add(drBloodUnitPreXmatchTest);

			DataRow drBloodUnitPostXmatchTest = dtBloodUnitTest.NewRow();
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.BloodUnitTestGuid] = Guid.NewGuid();
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.BloodUnitGuid] = bloodUnitGuid;
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.BloodTestTypeId] = 110;
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.TestDate] = DateTime.Now;
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.TestResultId] = "P";
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.EntryMethodCode] = "M";
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.OrderedTestGuid] = orderedTestGuid;
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.TestingMethodCode] = "T";
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.TestTechId] = Common.LogonUser.LogonUserName;
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.RackGuid] = rackGuid;
			drBloodUnitPostXmatchTest[TABLES.BloodUnitTest.AutoInstrumentName] = DBNull.Value;
			dtBloodUnitTest.Rows.Add(drBloodUnitPostXmatchTest);

			DataTable dtOrderedTest = new DataTable();
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
//			dtOrderedTest.Columns.Add(TABLES.OrderedTest.PatientSpecimenGuid, typeof(Guid));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.TaskStatusCode, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.OrderStatusCode, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.LastUpdateUser, typeof(string));
//			dtOrderedTest.Columns.Add(TABLES.OrderedTest.DivisionCode, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.RowVersion, typeof(byte []));

			DataRow drOrderedTest = dtOrderedTest.NewRow();
			drOrderedTest[TABLES.OrderedTest.OrderedTestGuid] = orderedTestGuid;
//			drOrderedTest[TABLES.OrderedTest.PatientSpecimenGuid] = postPatientSpecimenGuid;
			drOrderedTest[TABLES.OrderedTest.TaskStatusCode] = "C";
			drOrderedTest[TABLES.OrderedTest.OrderStatusCode] = "A";
			drOrderedTest[TABLES.OrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
//			drOrderedTest[TABLES.OrderedTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drOrderedTest[TABLES.OrderedTest.RowVersion] = orderedTest.RowVersion;
			dtOrderedTest.Rows.Add(drOrderedTest);
			// ************************************************************************************************************
			//Create workload data
			Guid [] patientGuids = new Guid[1];
			patientGuids[0] = Guid.NewGuid();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.TransfusionReactionInvestigation, patientGuids, Common.WorkloadTransactionType.Patient, false);

			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.QC_not_performed_on_rack_used_for_testing, "Unit Test 4648", Environment.UserName);
			exRep.GenerateExceptionQCNotPerformed(new BOL.Patient(patientGuid), new BOL.Specimen(postPatientSpecimenGuid), new BOL.Rack(rackGuid).RackName, Environment.UserName );
			DataTable rackNotTestedExceptions = exRep.ExceptionData.Table.Clone();
			rackNotTestedExceptions.Rows.Add(exRep.ExceptionData.ItemArray);

			bool success = DAL.PatientTransfusionReaction.SaveSerologicTests(dtPatientTransfusionReaction, dtSpecimenTest, dtBloodUnitTest, dtOrderedTest, rackNotTestedExceptions, Common.UpdateFunction.UnitTests, dtWorkloadEvents);
			Assert.AreEqual(true, success, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void SaveSerologicTests_Fail()
		{
			DataTable dtOrderedTest = new DataTable();
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.PatientSpecimenGuid, typeof(Guid));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.TaskStatusCode, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.OrderStatusCode, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.LastUpdateUser, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.DivisionCode, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.RowVersion, typeof(byte []));

			DataRow drOrderedTest=dtOrderedTest.NewRow();

			dtOrderedTest.Rows.Add(drOrderedTest);
			//Create workload data
			Guid [] patientGuids = new Guid[1];
			patientGuids[0] = Guid.NewGuid();
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.TransfusionReactionInvestigation);
			DataTable dtWorkloadEvents = BOL.WorkloadEvent.GenerateWorkloadData(Common.WorkloadProcessID.TransfusionReactionInvestigation, patientGuids, Common.WorkloadTransactionType.Patient, false);
			
			DAL.PatientTransfusionReaction.SaveSerologicTests (new DataTable(), new DataTable(), new DataTable(), dtOrderedTest, null, Common.UpdateFunction.UnitTests, dtWorkloadEvents);
		}

		[Test]
		public void SaveSpecimenChecks_Pass()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			Guid patientTransfusionReactionGuid = Guid.NewGuid();

			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PatientGuid, typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.NotedDateTime, typeof(DateTime));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.InvestigatedDateTime, typeof(DateTime));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.EntryTechId, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.EntryDateTime, typeof(DateTime));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.OrderedTestGuid, typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator, typeof(int));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator, typeof(int));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator, typeof(int));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator, typeof(int));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode, typeof(char));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode, typeof(char));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PartialSaveId, typeof(byte));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RecordStatusCode, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));

			DataRow drPatientTransfusionReaction = dtPatientTransfusionReaction.NewRow();
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid] = patientTransfusionReactionGuid;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PatientGuid] = patientGuid;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.NotedDateTime] = VbecsDateTime.GetDivisionCurrentDateTime();
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.InvestigatedDateTime] = VbecsDateTime.GetDivisionCurrentDateTime();
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.EntryTechId] = Common.LogonUser.LogonUserName;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.EntryDateTime] = DateTime.Now;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.OrderedTestGuid] = orderedTestGuid;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator] = 1;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator] = 0;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator] = 0;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator] = 1;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode] = DBNull.Value;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode] = 'I';
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PartialSaveId] = 1;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.RecordStatusCode] = "A";
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtPatientTransfusionReaction.Rows.Add(drPatientTransfusionReaction);
			// ****************************************************************************************************************************
			BOL.OrderedTest orderedTest = new BOL.OrderedTest(orderedTestGuid, patientOrderGuid);
			DataTable dtOrderedTest = new DataTable();
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
//			dtOrderedTest.Columns.Add(TABLES.OrderedTest.PatientSpecimenGuid, typeof(Guid));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.TaskStatusCode, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.OrderStatusCode, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.LastUpdateUser, typeof(string));
//			dtOrderedTest.Columns.Add(TABLES.OrderedTest.DivisionCode, typeof(string));
			dtOrderedTest.Columns.Add(TABLES.OrderedTest.RowVersion, typeof(byte []));

			DataRow drOrderedTest = dtOrderedTest.NewRow();
			drOrderedTest[TABLES.OrderedTest.OrderedTestGuid] = orderedTestGuid;
//			drOrderedTest[TABLES.OrderedTest.PatientSpecimenGuid] = postPatientSpecimenGuid;
			drOrderedTest[TABLES.OrderedTest.TaskStatusCode] = Common.TaskStatus.InProgress;
			drOrderedTest[TABLES.OrderedTest.OrderStatusCode] = Common.OrderStatus.Accepted;
			drOrderedTest[TABLES.OrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
//			drOrderedTest[TABLES.OrderedTest.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drOrderedTest[TABLES.OrderedTest.RowVersion] = orderedTest.RowVersion;
			dtOrderedTest.Rows.Add(drOrderedTest);
			// ****************************************************************************************************************************
			DataTable dtPatientTransfusionComment = new DataTable();
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.CannedCommentGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.CommentCategoryCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionCommentText, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.DivisionCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.RecordStatusCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.LastUpdateUser, typeof(string));

			DataRow drSpecimenComment = dtPatientTransfusionComment.NewRow();
			drSpecimenComment[TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid] = Guid.NewGuid();
			drSpecimenComment[TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid] = patientTransfusionReactionGuid;
			drSpecimenComment[TABLES.PatientTransfusionComment.CannedCommentGuid] = DBNull.Value;
			drSpecimenComment[TABLES.PatientTransfusionComment.CommentCategoryCode] = "T1";
			drSpecimenComment[TABLES.PatientTransfusionComment.PatientTransfusionCommentText] = "TESTING " + DateTime.Now;
			drSpecimenComment[TABLES.PatientTransfusionComment.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drSpecimenComment[TABLES.PatientTransfusionComment.RecordStatusCode] = "A";
			drSpecimenComment[TABLES.PatientTransfusionComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtPatientTransfusionComment.Rows.Add(drSpecimenComment);

			BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Transfusion_Reaction_Workup, "Unit Test 4634", Environment.UserName);
			exRep.GenerateExceptionTrwSpecimen(new BOL.PatientTransfusionReaction(drPatientTransfusionReaction),new BOL.Patient(patientGuid),new BOL.Specimen(postPatientSpecimenGuid),false);
			DataTable specimenClericalCheckExceptions = exRep.ExceptionData.Table.Clone();
			specimenClericalCheckExceptions.Rows.Add(exRep.ExceptionData.ItemArray);

			bool success = DAL.PatientTransfusionReaction.SaveSpecimenChecks(dtPatientTransfusionReaction, dtOrderedTest, dtPatientTransfusionComment, specimenClericalCheckExceptions, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, success, "Error saving specimen checks:");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void SaveSpecimenChecks_Fail()
		{
			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PatientGuid, typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.NotedDateTime, typeof(DateTime));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.InvestigatedDateTime, typeof(DateTime));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.EntryTechId, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.EntryDateTime, typeof(DateTime));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.OrderedTestGuid, typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator, typeof(int));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator, typeof(int));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator, typeof(int));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator, typeof(int));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PreSpecimenHemolysisInspectionCode, typeof(char));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PostSpecimenHemolysisInspectionCode, typeof(char));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PartialSaveId, typeof(byte));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RecordStatusCode, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));

			DataRow drPTR=dtPatientTransfusionReaction.NewRow();

			dtPatientTransfusionReaction.Rows.Add(drPTR);

			bool success = DAL.PatientTransfusionReaction.SaveSpecimenChecks( dtPatientTransfusionReaction , new DataTable(), new DataTable(), null, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(false, success, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void SaveSpecimenChecks_EmptyTable_Fail()
		{
			bool success = DAL.PatientTransfusionReaction.SaveSpecimenChecks( new DataTable() , new DataTable(), new DataTable(), null, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(false, success, "ReturnValue");
		}

		[Test]
		public void SaveSymptons_Pass()
		{
			this.RefreshData = true;

            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;
			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][TABLES.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid prePatientSpecimenGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientSpecimen(prePatientSpecimenGuid, patientGuid, true);

			Guid postPatientSpecimenGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertPatientSpecimen(postPatientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			BOL.UnitTests.BOL_PatientTransfusionReaction.InsertOrderedTest(orderedTestGuid, patientOrderGuid, postPatientSpecimenGuid, Common.OrderableTest.TRW);

			BOL.PatientTransfusionReaction ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);
			BOL.OrderedTest orderedTest = new BOL.OrderedTest(orderedTestGuid, patientOrderGuid);
			//
			ptr.PatientGuid = patientGuid;
			ptr.NotedDateTime = DateTime.Now;
			ptr.InvestigatedDateTime = DateTime.Now;
			ptr.PreSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			ptr.PostSpecimenNotAvailableIndicator = false;
			ptr.PreSpecimenClericalChecksOKIndicator = true;
			BOL.Specimen preSpecimen = new BOL.Specimen(prePatientSpecimenGuid);
			preSpecimen.PostTransfusionIndicator = false;
			ptr.PreSpecimenHemolysisInspectionCode = "1";
			BOL.Specimen postSpecimen = new BOL.Specimen(postPatientSpecimenGuid);
			postSpecimen.PostTransfusionIndicator = true;
			ptr.PostSpecimenHemolysisInspectionCode = "1";
			//
			ptr.PreSpecimenGuid = preSpecimen.SpecimenGuid;
			ptr.PostSpecimenGuid = postSpecimen.SpecimenGuid;
			orderedTest.Specimen = postSpecimen;
			//
			ptr.SaveSpecimenCheckData(orderedTest, new System.Collections.ArrayList(), null);
			ptr = new BOL.PatientTransfusionReaction(orderedTestGuid);

			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PartialSaveId, typeof(byte));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RowVersion, typeof(byte []));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));

			DataRow drPatientTransfusionReaction = dtPatientTransfusionReaction.NewRow();
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PartialSaveId] = 3;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.RowVersion] = ptr.RowVersion;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dtPatientTransfusionReaction.Rows.Add(drPatientTransfusionReaction);
			// ****************************************************************************************************************************
			DataTable dtPatientTransfusionReactionSymptom = new DataTable();
			dtPatientTransfusionReactionSymptom.Columns.Add(TABLES.PatientTransfusionReactionSymptom.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionReactionSymptom.Columns.Add(TABLES.PatientTransfusionReactionSymptom.PatientSymptomId, typeof(string));
			dtPatientTransfusionReactionSymptom.Columns.Add(TABLES.PatientTransfusionReactionSymptom.SortColumn, typeof(int));
			dtPatientTransfusionReactionSymptom.Columns.Add(TABLES.PatientTransfusionReactionSymptom.LastUpdateUser, typeof(string));

			// Insert "rash" and "chills" symptoms
			DataRow drRashSymptom = dtPatientTransfusionReactionSymptom.NewRow();
			drRashSymptom[TABLES.PatientTransfusionReactionSymptom.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drRashSymptom[TABLES.PatientTransfusionReactionSymptom.PatientSymptomId] = "1";
			drRashSymptom[TABLES.PatientTransfusionReactionSymptom.SortColumn] = 1;
			drRashSymptom[TABLES.PatientTransfusionReactionSymptom.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtPatientTransfusionReactionSymptom.Rows.Add(drRashSymptom);

			DataRow drChillsSymptom = dtPatientTransfusionReactionSymptom.NewRow();
			drChillsSymptom[TABLES.PatientTransfusionReactionSymptom.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drChillsSymptom[TABLES.PatientTransfusionReactionSymptom.PatientSymptomId] = "2";
			drChillsSymptom[TABLES.PatientTransfusionReactionSymptom.SortColumn] = 2;
			drChillsSymptom[TABLES.PatientTransfusionReactionSymptom.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtPatientTransfusionReactionSymptom.Rows.Add(drChillsSymptom);
			// ****************************************************************************************************************************
			DataTable dtPatientTransfusionComment = new DataTable();
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.CannedCommentGuid, typeof(Guid));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.CommentCategoryCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionCommentText, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.LastUpdateUser, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.DivisionCode, typeof(string));
			dtPatientTransfusionComment.Columns.Add(TABLES.PatientTransfusionComment.RecordStatusCode, typeof(string));

			DataRow drOtherSymptomDetailsComment = dtPatientTransfusionComment.NewRow();
			drOtherSymptomDetailsComment[TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid] = Guid.NewGuid();
			drOtherSymptomDetailsComment[TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid] = ptr.PatientTransfusionReactionGuid;
			drOtherSymptomDetailsComment[TABLES.PatientTransfusionComment.CannedCommentGuid] = DBNull.Value;
			drOtherSymptomDetailsComment[TABLES.PatientTransfusionComment.CommentCategoryCode] = "T4";
			drOtherSymptomDetailsComment[TABLES.PatientTransfusionComment.PatientTransfusionCommentText] = "No more details really, just testing. " + DateTime.Now;
			drOtherSymptomDetailsComment[TABLES.PatientTransfusionComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drOtherSymptomDetailsComment[TABLES.PatientTransfusionComment.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drOtherSymptomDetailsComment[TABLES.PatientTransfusionComment.RecordStatusCode] = "A";

			dtPatientTransfusionComment.Rows.Add(drOtherSymptomDetailsComment);

			bool success = DAL.PatientTransfusionReaction.SaveSymptons (dtPatientTransfusionReaction, dtPatientTransfusionReactionSymptom, dtPatientTransfusionComment, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, success, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.DataAccessLayerException))]
		public void SaveSymptons_Fail()
		{
			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PartialSaveId, typeof(byte));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RowVersion, typeof(byte []));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));

			DataRow drPTR=dtPatientTransfusionReaction.NewRow();

			dtPatientTransfusionReaction.Rows.Add(drPTR);

			DAL.PatientTransfusionReaction.SaveSymptons( dtPatientTransfusionReaction , new DataTable(), new DataTable(), Common.UpdateFunction.UnitTests);
		}
		
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void SaveSymptons_EmptyTable_Fail()
		{
			DAL.PatientTransfusionReaction.SaveSymptons( new DataTable(), new DataTable(), new DataTable(), Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void UpdateStatus_Pass()
		{
			this.RefreshData = true;
		
			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RecordStatusCode, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RowVersion, typeof(byte []));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));

			DataRow drPatientTransfusionReaction = dtPatientTransfusionReaction.NewRow();
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid] = this._existingData["PatientTransfusionReactionGuid"];
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.RecordStatusCode] = "A";
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.RowVersion] = this._existingData["RowVersion"];
			drPatientTransfusionReaction[TABLES.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dtPatientTransfusionReaction.Rows.Add(drPatientTransfusionReaction);

			bool success = DAL.PatientTransfusionReaction.UpdateStatus(dtPatientTransfusionReaction, Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, success, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void UpdateStatus_Fail()
		{
			DataTable dtPatientTransfusionReaction = new DataTable();
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RecordStatusCode, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.RowVersion, typeof(byte []));
			dtPatientTransfusionReaction.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));

			DataRow drPTR=dtPatientTransfusionReaction.NewRow();

			dtPatientTransfusionReaction.Rows.Add(drPTR);

			DAL.PatientTransfusionReaction.UpdateStatus( dtPatientTransfusionReaction, Common.UpdateFunction.UnitTests );
			
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void UpdateStatus_EmptyTable_Fail()
		{
			DAL.PatientTransfusionReaction.UpdateStatus( new DataTable(), Common.UpdateFunction.UnitTests );
		}

		[Test]
		public void FinalizeReport_Pass()
		{
			this.RefreshData = true;
			
			Guid ptrGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientTransfusionReactionGuid FROM PatientTransfusionReaction WHERE DivisionCode = '" + this.TestDivisionCode + "'");
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM PatientTransfusionReaction WHERE PatientTransfusionReactionGuid = '" + ptrGuid.ToString() + "'");
			byte[] ptrRowVersion = (byte[])dtTest.Rows[0][TABLES.PatientTransfusionReaction.RowVersion];

			DataTable dtPTR = SprocHelper.GetFinalizePatientTransfusionReaction(ptrGuid, ptrRowVersion);
			DataTable dtPTC = SprocHelper.GetInsertPatientTransfusionCommentSprocTable(Guid.NewGuid(), ptrGuid);

			bool retValue = DAL.PatientTransfusionReaction.FinalizeReport(dtPTR, dtPTC, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(Common.RowVersionException))]
		public void FinalizeReport_Fail()
		{
			Guid ptrGuid = DataCreator.GetRecordGuid("SELECT TOP 1 PatientTransfusionReactionGuid FROM PatientTransfusionReaction WHERE DivisionCode = '" + this.TestDivisionCode + "'");
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM PatientTransfusionReaction WHERE PatientTransfusionReactionGuid = '" + ptrGuid.ToString() + "'");
			byte[] ptrRowVersion = new byte[8];

			DataTable dtPTR = SprocHelper.GetFinalizePatientTransfusionReaction(ptrGuid, ptrRowVersion);
			DataTable dtPTC = SprocHelper.GetInsertPatientTransfusionCommentSprocTable(Guid.NewGuid(), ptrGuid);

			DAL.PatientTransfusionReaction.FinalizeReport(dtPTR, dtPTC, Common.UpdateFunction.UnitTests);
		}

		#region Helper Methods

		private DataRow GetPtrData()
		{
			string strSQL = "SELECT TOP 1 PTR.PatientTransfusionReactionGuid, PTR.PatientGuid,  ";
			strSQL = string.Concat(strSQL, " PTR.OrderedTestGuid, PTR.RowVersion, OT.PatientSpecimenGuid,  ");
			strSQL = string.Concat(strSQL, " PRE.PatientSpecimenGuid AS PreSpecimenGuid, PT.BloodUnitGuid FROM PatientTransfusionReaction PTR");
			strSQL = string.Concat(strSQL, " JOIN PatientTransfusion PT ON PTR.PatientGuid = PT.PatientGuid");
			strSQL = string.Concat(strSQL, " JOIN OrderedTest OT ON PTR.OrderedTestGuid = OT.OrderedTestGuid");
			strSQL = string.Concat(strSQL, " LEFT OUTER JOIN PatientSpecimen PRE ON PTR.PreSpecimenGuid = PRE.PatientSpecimenGuid ");
			strSQL = string.Concat(strSQL, " LEFT OUTER JOIN PatientSpecimen POST ON PTR.PreSpecimenGuid = POST.PatientSpecimenGuid ");
			strSQL = string.Concat(strSQL, " WHERE OT.PatientSpecimenGuid IS NOT NULL AND PTR.RecordStatusCode <> 'X' AND PTR.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");
	
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(strSQL, false);
			if (dtTemp.Rows.Count == 0)
			{
				new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveImplicatedBloodUnits_Pass();
				dtTemp = UnitTestUtil.RunSQLGetDataTable(strSQL, true);
			}

			return  dtTemp.Rows[0];
		}

		private DataRow GetDataForPersistingNewPtr()
		{
			// Load the guids we'll need for a majority of the tests here
			StringBuilder query = new StringBuilder("SELECT TOP 1 Patient.PatientGuid, ");
			query.Append("PatientTransfusion.PatientTransfusionGuid, PatientTransfusion.BloodUnitGuid, ");
			query.Append("PatientTreatment.PatientTreatmentGuid, PatientOrder.PatientOrderGuid,  ");
			query.Append("OrderedTest.OrderedTestGuid, OrderedTest.RowVersion AS OrderedTestRowVersion, ");
			query.Append("PSPRE.PatientSpecimenGuid AS PreSpecimenGuid, PSPRE.Specimenuid AS PreSpecimenuid, ");
			query.Append("PSPRE.RowVersion AS PreSpecimenRowVersion, ");
			query.Append("PSPOST.PatientSpecimenGuid AS PostSpecimenGuid, PSPOST.Specimenuid AS PostSpecimenuid, ");
			query.Append("PSPOST.RowVersion AS PostSpecimenRowVersion ");
			query.Append(" FROM Patient ");
			query.Append("JOIN PatientTransfusion ON Patient.PatientGuid = PatientTransfusion.PatientGuid ");
			query.Append("JOIN PatientTreatment ON Patient.PatientGuid = PatientTreatment.PatientGuid ");
			query.Append("JOIN PatientOrder ON PatientTreatment.PatientTreatmentGUID = PatientOrder.PatientTreatmentGuid ");
			query.Append("JOIN OrderedTest ON PatientOrder.PatientOrderGuid = OrderedTest.PatientOrderGuid ");
			query.Append("JOIN PatientTransfusionReaction PTR ON OrderedTest.OrderedTestGuid = PTR.OrderedTestGuid ");
			query.Append("LEFT OUTER JOIN PatientSpecimen AS PSPOST ON PTR.PostSpecimenGuid = PSPOST.PatientSpecimenGuid ");
			query.Append("LEFT OUTER JOIN PatientSpecimen AS PSPRE ON PTR.PreSpecimenGuid = PSPRE.PatientSpecimenGuid ");
			query.Append("WHERE PatientOrder.DivisionCode = '").Append(UnitTestConfig.TestDivisionCode).Append("' ");
			query.Append("AND OrderedTest.DivisionCode = '").Append(UnitTestConfig.TestDivisionCode).Append("' ");
			query.Append("AND PSPOST.PatientSpecimenGuid IS NOT NULL");

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(query.ToString(), false);
			if (dtTemp.Rows.Count == 0)
			{
				new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveImplicatedBloodUnits_Pass();
				dtTemp = UnitTestUtil.RunSQLGetDataTable(query.ToString(), true);
			}
						
			return dtTemp.Rows[0];
		}

		// Added 3/1/2005 RDH 
		private DataTable GetDataForOrderedTest()
		{
			// Load the guids we'll need for a majority of the tests here
			StringBuilder query = new StringBuilder("SELECT TOP 1 ");
			query.Append("OT.PatientSpecimenGuid, ");
			query.Append("PTR.PreSpecimenGuid, ");
			query.Append("OT.TaskStatusCode, ");
			query.Append("OT.OrderStatusCode, ");
			query.Append("OT.DivisionCode, ");
			query.Append("OT.LastUpdateDate, ");
			query.Append("OT.LastUpdateUser, ");
			query.Append("OT.LastUpdateFunctionId, ");
			query.Append("OT.OrderedTestGuid, ");
			query.Append("OT.[RowVersion] ");
			query.Append("FROM OrderedTest OT JOIN PatientTransfusionReaction PTR ON PTR.OrderedTestGuid = OT.OrderedTestGuid WHERE OT.DivisionCode = '"+UnitTestConfig.TestDivisionCode+"' ");

			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(query.ToString(), false);
			if (dtTemp.Rows.Count == 0)
			{
				new BOL.UnitTests.BOL_PatientTransfusionReaction().SaveImplicatedBloodUnits_Pass();
				dtTemp = UnitTestUtil.RunSQLGetDataTable(query.ToString(), true);
			}
						
			return dtTemp;
		}


		//Creates test data, because this crap fades fast for some reason
		private void CreateTestData()
		{
			
			Guid patientTransfusionGuid = Guid.NewGuid();
			Guid patientTransfusionReactionGuid = Guid.NewGuid();
			Guid transfusionReactionGuid = Guid.NewGuid();
			string sql = string.Empty;


			sql = " INSERT INTO PatientTransfusion (PatientTransfusionGuid, PatientGuid,  " + 
				               " LastUpdateUser, LastUpdateDate, LastUpdateFunctionId, RecordStatusCode, DivisionCode)" +
				  " VALUES ('" + patientTransfusionGuid.ToString() + "','" + this._dtPatient.Rows[0][TABLES.Patient.PatientGuid].ToString() + "','" +
				  Common.LogonUser.LogonUserName + "','" + DateTime.Now.ToString() + "',999,'A','" + UnitTestConfig.TestDivisionCode + "')";
			int uCheck = UnitTestUtil.RunSQL(sql);

			//Create the PatientTransfusionReaction Data
			sql = " INSERT INTO PatientTransfusionReaction (PatientTransfusionReactionGuid, PatientGuid,  " + 
				" LastUpdateUser, LastUpdateDate, LastUpdateFunctionId, RecordStatusCode, TransfusionReactionTypeCode, DivisionCode)" +
				" VALUES ('" + patientTransfusionReactionGuid.ToString() + "','" + this._dtPatient.Rows[0][TABLES.Patient.PatientGuid].ToString() + "','" +
				Common.LogonUser.LogonUserName + "','" + DateTime.Now.ToString() + "',999,'A','A','" + UnitTestConfig.TestDivisionCode + "')";
			uCheck = UnitTestUtil.RunSQL(sql);

			//Create the TransfusionReaction Data
			sql = " INSERT INTO TransfusionReaction (TransfusionReactionGuid, PatientTransfusionGuid, PatientTransfusionReactionGuid, " + 
				" LastUpdateUser, LastUpdateDate, LastUpdateFunctionId)" +
				" VALUES ('" + transfusionReactionGuid.ToString() + "','" + patientTransfusionGuid.ToString() + "','" + patientTransfusionReactionGuid.ToString() + "','" + 
				Common.LogonUser.LogonUserName + "','" + DateTime.Now.ToString() + "',999)";
			uCheck = UnitTestUtil.RunSQL(sql);

		}


		#endregion
	}
}
#endif
